(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7034,        209]*)
(*NotebookOutlinePosition[      7714,        232]*)
(*  CellTagsIndexPosition[      7670,        228]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    \(f[t_] := 1\  /; Abs[t] < 1/2\), "\[IndentingNewLine]", 
    \(f[t_] := 0\  /; \ Abs[t] \[GreaterEqual] 1/2\)}], "Input"],

Cell[BoxData[
    \(\(Plot[f[t], {t, \(-2\), 2}, AspectRatio \[Rule]  .41, 
        Ticks \[Rule] {Automatic, { .5,  .5}}];\)\)], "Input"],

Cell[BoxData[
    \(Display["\<rect1.eps\>", %, "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    \(Display["\<rect1.pdf\>", %, "\<PDF\>"]\)], "Input"],

Cell[BoxData[
    \(g[t_] := f[t] + f[t + 10] + f[t - 10]\)], "Input"],

Cell[BoxData[
    \(\(Plot[g[t], {t, \(-15\), 15}, AspectRatio \[Rule]  .20, 
        Ticks \[Rule] {Automatic, None}];\)\)], "Input"],

Cell[BoxData[
    \(Display["\<rect2.eps\>", %, "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    \(Display["\<rect2.pdf\>", %, "\<PDF\>"]\)], "Input"],

Cell[BoxData[
    \(g[t_] := f[t] + f[t + 15] + f[t - 15]\)], "Input"],

Cell[BoxData[
    \(\(Plot[g[t], {t, \(-20\), 20}, AspectRatio \[Rule]  .15, 
        Ticks \[Rule] {Automatic, None}];\)\)], "Input"],

Cell[BoxData[
    \(Display["\<rect3.eps\>", %, "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    \(Display["\<rect3.pdf\>", %, "\<PDF\>"]\)], "Input"],

Cell[BoxData[
    \(Show[GraphicsArray[{Out[27], Out[37], Out[41]}]]\)], "Input"],

Cell[BoxData[
    \(c[n_, T_] := \(c[n, T] = 
        Simplify[\((1/T)\)*
            Integrate[Exp[\(-2\)\ \[Pi]\ I\ n\ t/T], {t, \(-1\)/2, 1/2}], 
          n \[Element] Integers]\)\)], "Input"],

Cell[BoxData[
    \(Clear[c]\)], "Input"],

Cell[BoxData[{
    \(c[n, T]\), "\[IndentingNewLine]", 
    \(c[0, T]\)}], "Input"],

Cell[BoxData[{
    \(a[n_] := \(a[n] = c[n] + c[\(-n\)]\)\), "\n", 
    \(b[n_] := \(b[n] = I \((c[n] - c[\(-n\)])\)\)\), "\[IndentingNewLine]", 
    \(a[n]\), "\[IndentingNewLine]", 
    \(b[n]\), "\[IndentingNewLine]", 
    \(a[0]/2\)}], "Input"],

Cell[BoxData[{
    \(sptampreal[q_, T_] := 
      Table[{k/T, T*c[k, T]}, {k, \(-q\), q, 1}]\), "\n", 
    \(SpectrumAmplitudesrealesPlot[q_, T_, opts___] := 
      Show[Graphics[{\((Line[{{#1[\([1]\)], 0}, #1}] &)\) /@ 
              sptampreal[q, T], \(({Hue[0], PointSize[ .014], Point[#]} &)\) /@ 
              sptampreal[q, T]}, opts]]\)}], "Input"],

Cell[BoxData[
    \(\(SpectrumAmplitudesrealesPlot[67, 15, PlotRange \[Rule] All, 
        Axes \[Rule] True, Ticks \[Rule] None, 
        ImageSize \[Rule] {448, 276.75}];\)\)], "Input"],

Cell[BoxData[
    \(\(SpectrumAmplitudesrealesPlot[45, 10, PlotRange \[Rule] All, 
        Axes \[Rule] True, Ticks \[Rule] None, 
        ImageSize \[Rule] {448, 276.75}];\)\)], "Input"],

Cell[BoxData[
    \(\(SpectrumAmplitudesrealesPlot[23, 5, PlotRange \[Rule] All, 
        Axes \[Rule] True, Ticks \[Rule] None, 
        ImageSize \[Rule] {448, 276.75}];\)\)], "Input"],

Cell[BoxData[
    \(Display["\<sinc1.eps\>", Out[64], "\<EPS\>"]\)], "Input"],

Cell[BoxData[{
    \(Display["\<sinc3.pdf\>", Out[21], "\<PDF\>"]\), "\[IndentingNewLine]", 
    \(Display["\<sinc2.pdf\>", Out[22], "\<PDF\>"]\), "\[IndentingNewLine]", 
    \(Display["\<sinc1.pdf\>", Out[23], "\<PDF\>"]\)}], "Input"],

Cell[BoxData[
    \(\(SpectrumAmplitudesrealesPlot[90, 20, PlotRange \[Rule] All, 
        Axes \[Rule] True, Ticks \[Rule] None, 
        ImageSize \[Rule] {448, 276.75}];\)\)], "Input"],

Cell[BoxData[
    \(\(Plot[Sin[\[Pi]\ t]/\((\[Pi]\ t)\), {t, \(-5\), 5}, 
        PlotRange \[Rule] All, Axes \[Rule] True, 
        ImageSize \[Rule] {448, 276.75}, AspectRatio \[Rule]  .4, 
        PlotStyle \[Rule] {Thickness[ .004], Hue[0]}, 
        PlotPoints \[Rule] 1000];\)\)], "Input"],

Cell[BoxData[
    \(Display["\<sincfunction.eps\>", %, "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    \(Display["\<sincfunction.pdf\>", %, "\<PDF\>"]\)], "Input"],

Cell[BoxData[
    \(Remove[f]\)], "Input"],

Cell[BoxData[{
    \(\(f[
          x_] := \(-1.5\) - x \((x - 1)\)^2\  /; \ \(-1\) \[LessEqual] 
            x <  .955;\)\), "\[IndentingNewLine]", 
    \(\(f[x_] := 0 /;  .95 \[LessEqual] x < 1;\)\), "\[IndentingNewLine]", 
    \(\(f[x_] :=  .4 +  .5\ \ x \((x - 1)\)^2 /; \ 
          1 \[LessEqual] x < 2.5;\)\), "\[IndentingNewLine]", 
    \(\(f[x_] := 0 /; 2.5 \[LessEqual] x < 2.55;\)\), "\[IndentingNewLine]", 
    \(\(f[x_] := \(-2\) + x \((x - 3)\)^2 /; \ 
          2.55 \[LessEqual] x \[LessEqual] \ 4;\)\)}], "Input"],

Cell[BoxData[
    \(Plot[f[x], {x, \(-1\), 4}]\)], "Input"],

Cell[BoxData[
    \(g1 = 
      Plot[x^2 -  .5, {x, \(- .5\), 1}, PlotRange \[Rule] All, 
        PlotStyle \[Rule] Thickness[ .0035]]\)], "Input"],

Cell[BoxData[
    \(g2 = 
      Plot[\(-Cos[3  x]\) - \((x - 2)\)^2 +  .8, {x, 1, 2.5}, 
        PlotRange \[Rule] All, 
        PlotStyle \[Rule] Thickness[ .0035]]\)], "Input"],

Cell[BoxData[
    \(g3 = 
      Plot[\((x - 3)\)^2 + Sin[3  x] -  .35, {x, 2.5, 4}, 
        PlotRange \[Rule] All, 
        PlotStyle \[Rule] Thickness[ .0035]]\)], "Input"],

Cell[BoxData[
    \(Show[{g1, g2, g3, 
        Graphics[{Dashing[{0.01, 0.007}], 
            Line[{{1,  .5}, {1, \(- .2\) - Cos[3]}}]}], 
        Graphics[{Dashing[{0.01, 0.007}], 
            Line[{{2.5,  .204}, {2.5,  .838}}]}]}, 
      AspectRatio \[Rule] Automatic, 
      Ticks \[Rule] {{{1, "\<a\>"}, {2.5, "\<b\>"}}, None}]\)], "Input"],

Cell[BoxData[
    \(Display["\<discont.eps\>", %, "\<EPS\>"]\)], "Input"]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 681}},
WindowSize->{1016, 643},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 141, 2, 70, "Input"],
Cell[1898, 55, 138, 2, 50, "Input"],
Cell[2039, 59, 71, 1, 50, "Input"],
Cell[2113, 62, 71, 1, 50, "Input"],
Cell[2187, 65, 70, 1, 50, "Input"],
Cell[2260, 68, 134, 2, 50, "Input"],
Cell[2397, 72, 71, 1, 50, "Input"],
Cell[2471, 75, 71, 1, 50, "Input"],
Cell[2545, 78, 70, 1, 50, "Input"],
Cell[2618, 81, 134, 2, 50, "Input"],
Cell[2755, 85, 71, 1, 50, "Input"],
Cell[2829, 88, 71, 1, 50, "Input"],
Cell[2903, 91, 81, 1, 50, "Input"],
Cell[2987, 94, 196, 4, 50, "Input"],
Cell[3186, 100, 41, 1, 50, "Input"],
Cell[3230, 103, 83, 2, 70, "Input"],
Cell[3316, 107, 248, 5, 130, "Input"],
Cell[3567, 114, 355, 6, 90, "Input"],
Cell[3925, 122, 187, 3, 50, "Input"],
Cell[4115, 127, 187, 3, 50, "Input"],
Cell[4305, 132, 186, 3, 50, "Input"],
Cell[4494, 137, 77, 1, 50, "Input"],
Cell[4574, 140, 235, 3, 90, "Input"],
Cell[4812, 145, 187, 3, 50, "Input"],
Cell[5002, 150, 295, 5, 70, "Input"],
Cell[5300, 157, 78, 1, 50, "Input"],
Cell[5381, 160, 78, 1, 50, "Input"],
Cell[5462, 163, 42, 1, 50, "Input"],
Cell[5507, 166, 530, 9, 130, "Input"],
Cell[6040, 177, 59, 1, 50, "Input"],
Cell[6102, 180, 147, 3, 50, "Input"],
Cell[6252, 185, 178, 4, 50, "Input"],
Cell[6433, 191, 174, 4, 50, "Input"],
Cell[6610, 197, 344, 7, 90, "Input"],
Cell[6957, 206, 73, 1, 50, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

